<?xml version="1.0" encoding="UTF-8"?>
<shader language="GLSL">
  <fragment><![CDATA[
uniform sampler2D rubyTexture;
uniform vec2 rubyInputSize;
uniform vec2 rubyOutputSize;
uniform vec2 rubyTextureSize;

#define TEX2D(c) texture2D(rubyTexture,(c))
#define PI 3.141592653589
#define phase 0.0
#define gamma 2.5

void main()
{
        vec2 xy = gl_TexCoord[0].xy;

   vec2 one          = 1.0/rubyTextureSize;
   xy = xy + vec2(0.0 , -0.5 * (phase + (1-phase) * rubyInputSize.y/rubyOutputSize.y) * one.y);

   vec2 uv_ratio     = fract(xy*rubyTextureSize);
   
   vec4 coeffs = vec4(1.0 + uv_ratio.x, uv_ratio.x, 1.0 - uv_ratio.x, 2.0 - uv_ratio.x);
   coeffs = (sin(PI * coeffs) * sin(PI * coeffs / 2.0)) / (coeffs * coeffs);
   coeffs = coeffs / (coeffs.x+coeffs.y+coeffs.z+coeffs.w);
   
   vec4 col;
   vec4 col2;   

   col  = clamp(coeffs.x * TEX2D(xy + vec2(-one.x,0.0)) + coeffs.y * TEX2D(xy) + coeffs.z * TEX2D(xy + vec2(one.x, 0.0)) + coeffs.w * TEX2D(xy + vec2(2 * one.x, 0.0)),0.0,1.0);
   col2 = clamp(coeffs.x * TEX2D(xy + vec2(-one.x,one.y)) + coeffs.y * TEX2D(xy + vec2(0.0, one.y)) + coeffs.z * TEX2D(xy + one) + coeffs.w * TEX2D(xy + vec2(2 * one.x, one.y)),0.0,1.0);
   col =  pow(col,  vec4(gamma));
   col2 = pow(col2, vec4(gamma));

   vec4 wid = 0.2 + 0.4 * pow(col, 2.0);
   vec4 weights = uv_ratio.y/wid;
   weights = 0.51*exp(-weights*weights)/wid;
   wid = 0.2 + 0.4 * pow(col2,2.0);
   vec4 weights2 = (1.0-uv_ratio.y)/wid;
   weights2 = 0.51*exp(-weights2*weights2)/wid;

   gl_FragColor = pow(col * weights + col2 * weights2, 1.0/2.2);
}
  ]]></fragment>
</shader>